/*
 * Decompiled with CFR 0.152.
 */
package Entity;

import GameState.GameStateManager;
import Handlers.Options;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JOptionPane;

public class PlayerSave {
    private static int health = 3;
    private static int score = 0;
    private static long time = 0L;
    private static String weapon;
    private static Color color;
    private static String[] highscores;
    private static String[] highScoresTemp;
    private static String url;
    private static String user;
    private static String password;
    public static boolean online;
    public static String onlineText;
    public static boolean loading;
    private static int tripleBulletAmmo;
    private static int missilesAmmo;
    private static int beamAmmo;
    public static int tripleBulletAmmoAdd;
    public static int missilesAmmoAdd;
    public static int beamAmmoAdd;
    private static int maxTripleBulletAmmo;
    private static int maxMissilesAmmo;
    private static int maxBeamAmmo;
    private static int powerUpState;
    public static final int BULLET = 0;
    public static final int TRIPLEBULLET = 1;
    public static final int MISSILES = 2;
    public static final int BEAM = 3;
    private static double shieldTime;
    private static double shieldMaxTime;
    private static boolean shieldOn;
    public static final int EASY = 0;
    public static final int NORMAL = 1;
    public static final int HARD = 2;
    private static int difficulty;
    public static String difficultyString;

    static {
        highScoresTemp = new String[]{"TBD:-1", "TBD:-1", "TBD:-1", "TBD:-1", "TBD:-1", "TBD:-1", "TBD:-1", "TBD:-1", "TBD:-1", "TBD:-1"};
        url = "jdbc:mysql://work4games.no-ip.org:3306/cometdefender";
        user = "monty";
        password = "doge17";
        online = false;
        onlineText = "Local";
        loading = false;
        tripleBulletAmmoAdd = 20;
        missilesAmmoAdd = 10;
        beamAmmoAdd = 200;
        maxTripleBulletAmmo = 99;
        maxMissilesAmmo = 99;
        maxBeamAmmo = 999;
        shieldTime = 0.0;
        shieldMaxTime = 10.0;
        shieldOn = false;
        difficulty = 1;
        difficultyString = "Normal";
    }

    public static void init() {
        health = 3;
        score = 0;
        time = 0L;
        powerUpState = 0;
        tripleBulletAmmo = 0;
        missilesAmmo = 0;
        beamAmmo = 0;
    }

    public static int getHealth() {
        return health;
    }

    public static void setHealth(int i) {
        health = i;
    }

    public static void addHealth(int i) {
        if ((health += i) < 0) {
            health = 0;
        }
    }

    public static void setText() {
        if (powerUpState == 3) {
            weapon = "Hyper Beam";
            color = Color.BLUE;
        } else if (powerUpState == 1) {
            weapon = "Triple Shot";
            color = Color.RED;
        } else if (powerUpState == 2) {
            weapon = "Missiles";
            color = Color.GREEN;
        } else {
            weapon = "Bullet";
            color = Color.WHITE;
        }
    }

    public static void subAmmo(int power, int ammount) {
        if (power == 3) {
            if ((beamAmmo -= ammount) < 0) {
                beamAmmo = 0;
            }
        } else if (power == 1) {
            if ((tripleBulletAmmo -= ammount) < 0) {
                tripleBulletAmmo = 0;
            }
        } else if (power == 2 && (missilesAmmo -= ammount) < 0) {
            missilesAmmo = 0;
        }
    }

    public static void addAmmo(int power) {
        if (power == 3) {
            if ((beamAmmo += beamAmmoAdd) > maxBeamAmmo) {
                beamAmmo = maxBeamAmmo;
            }
        } else if (power == 1) {
            if ((tripleBulletAmmo += tripleBulletAmmoAdd) > maxTripleBulletAmmo) {
                tripleBulletAmmo = maxTripleBulletAmmo;
            }
        } else if (power == 2 && (missilesAmmo += missilesAmmoAdd) > maxMissilesAmmo) {
            missilesAmmo = maxMissilesAmmo;
        }
    }

    public static int getAmmo(int power) {
        int i = 0;
        if (power == 3) {
            i = beamAmmo;
        } else if (power == 1) {
            i = tripleBulletAmmo;
        } else if (power == 2) {
            i = missilesAmmo;
        }
        return i;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void getHighScores(boolean global) {
        if (!global) {
            FileReader fr = null;
            BufferedReader br = null;
            highscores = highScoresTemp;
            try {
                try {
                    fr = new FileReader(String.valueOf(System.getProperty("user.home")) + "/Documents/CometDefender/" + "HighScores_" + difficultyString + ".dat");
                    br = new BufferedReader(fr);
                    int i = 0;
                    while (i < highscores.length) {
                        PlayerSave.highscores[i] = br.readLine();
                        ++i;
                    }
                    return;
                }
                catch (Exception e) {
                    System.out.println("Error Loading " + difficultyString + " Local High Scores!");
                    highscores = highScoresTemp;
                    try {
                        if (br == null) return;
                        br.close();
                        return;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        System.out.println("2");
                    }
                }
                return;
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.out.println("2");
                }
            }
        }
        if (!global || !Options.getOption(6)) return;
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            Connection myConn = DriverManager.getConnection(url, user, password);
            Statement myStmt = myConn.createStatement();
            ResultSet myRs = myStmt.executeQuery("select * from " + difficultyString + "_high_scores");
            int i = 0;
            while (myRs.next()) {
                PlayerSave.highscores[i] = myRs.getString("name_score");
                ++i;
            }
            myRs.close();
            myStmt.close();
            myConn.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            PlayerSave.setOnline(false);
            JOptionPane.showMessageDialog(null, "Error Connecting To Online Leaderboards! Try Again Later");
        }
    }

    public static void setHighScores() {
        int n;
        int j;
        String name = "";
        String[] tempScore = new String[]{"", "", "", "", "", "", "", "", "", ""};
        if (GameStateManager.getState() != 3 && GameStateManager.getState() != 4 && Options.getOption(6)) {
            PlayerSave.getHighScores(true);
            int i = 0;
            while (i < highscores.length) {
                if (score > Integer.parseInt(highscores[i].split(":")[1])) {
                    int k = 0;
                    j = i;
                    while (j < highscores.length) {
                        tempScore[k] = highscores[j];
                        ++k;
                        ++j;
                    }
                    k = 0;
                    n = i;
                    while (n < highscores.length - 1) {
                        PlayerSave.highscores[n + 1] = tempScore[k];
                        ++k;
                        ++n;
                    }
                    name = JOptionPane.showInputDialog("New Online and Local High Score! Please Enter your name:");
                    if (name == null || name.equals("")) {
                        name = "Anonymous";
                    }
                    PlayerSave.highscores[i] = String.valueOf(name) + ":" + score;
                    break;
                }
                ++i;
            }
            try {
                Connection myConn = DriverManager.getConnection(url, user, password);
                Statement myStmt = myConn.createStatement();
                int i2 = 0;
                while (i2 < highscores.length) {
                    String sql = "UPDATE " + difficultyString + "_high_scores set name_score='" + highscores[i2] + "' where id=" + (i2 + 1);
                    myStmt.executeUpdate(sql);
                    ++i2;
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error Connecting To Online Leaderboards! Try Again Later");
                e.printStackTrace();
            }
        }
        PlayerSave.getHighScores(false);
        tempScore = new String[]{"", "", "", "", "", "", "", "", "", ""};
        int i = 0;
        while (i < highscores.length) {
            if (score > Integer.parseInt(highscores[i].split(":")[1]) && score != 0) {
                int k = 0;
                j = i;
                while (j < highscores.length) {
                    tempScore[k] = highscores[j];
                    ++k;
                    ++j;
                }
                k = 0;
                n = i;
                while (n < highscores.length - 1) {
                    PlayerSave.highscores[n + 1] = tempScore[k];
                    ++k;
                    ++n;
                }
                if (name == "") {
                    name = JOptionPane.showInputDialog("New Local High Score! Please Enter your name:");
                }
                if (name == null || name.equals("")) {
                    name = "Anonymous";
                }
                PlayerSave.highscores[i] = String.valueOf(name) + ":" + score;
                break;
            }
            ++i;
        }
        boolean success = new File(String.valueOf(System.getProperty("user.home")) + "/Documents/CometDefender").mkdirs();
        File scoreFile = new File(String.valueOf(System.getProperty("user.home")) + "/Documents/CometDefender/" + "HighScores_" + difficultyString + ".dat");
        if (!scoreFile.exists()) {
            try {
                scoreFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            try {
                fw = new FileWriter(scoreFile);
                bw = new BufferedWriter(fw);
                int i3 = 0;
                while (i3 < highscores.length) {
                    bw.write(highscores[i3]);
                    if (i3 != highscores.length - 1) {
                        bw.newLine();
                    }
                    ++i3;
                }
            }
            catch (Exception exception) {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void drawHighScore(Graphics2D g, Font font, int x, int y) {
        g.setFont(font);
        g.setColor(Color.WHITE);
        int i = 0;
        while (i < highscores.length / 2) {
            if (highscores[i].split(":")[1].equals("-1")) {
                g.drawString(String.valueOf(i + 1) + ". " + highscores[i].split(":")[0], x, y + 40 * i);
            } else {
                g.drawString(String.valueOf(i + 1) + ". " + highscores[i].split(":")[0] + " - " + highscores[i].split(":")[1], x, y + 40 * i);
            }
            ++i;
        }
        i = 0;
        while (i < highscores.length / 2) {
            if (highscores[i + 5].split(":")[1].equals("-1")) {
                g.drawString(String.valueOf(i + 6) + ". " + highscores[i + 5].split(":")[0], x + 350, y + 40 * i);
            } else {
                g.drawString(String.valueOf(i + 6) + ". " + highscores[i + 5].split(":")[0] + " - " + highscores[i + 5].split(":")[1], x + 350, y + 40 * i);
            }
            ++i;
        }
    }

    public static String getWeapon() {
        return weapon;
    }

    public static Color getColor() {
        return color;
    }

    public static int getScore() {
        return score;
    }

    public static void setScore(int i) {
        score = i;
    }

    public static void addScore(int i) {
        score += i;
    }

    public static int getPowerUpState() {
        return powerUpState;
    }

    public static void setPowerUpState(int i) {
        powerUpState = i;
    }

    public static int getDifficulty() {
        return difficulty;
    }

    public static void setDifficulty(int i) {
        PlayerSave.setHighScores();
        difficulty = i;
        if (i == 0) {
            difficultyString = "Easy";
        } else if (i == 1) {
            difficultyString = "Normal";
        } else if (i == 2) {
            difficultyString = "Hard";
        }
        PlayerSave.getHighScores(online);
    }

    public static void setOnline(boolean b) {
        online = b;
        PlayerSave.getHighScores(b);
        onlineText = b ? "Online" : "Local";
    }

    public static long getTime() {
        return time;
    }

    public static void setTime(long t) {
        time = t;
    }

    public static boolean getShieldOn() {
        return shieldOn;
    }

    public static void setShieldOn(boolean b) {
        shieldOn = b;
        shieldTime = shieldMaxTime;
    }

    public static double getShieldTime() {
        return shieldTime;
    }

    public static void addShieldTime(double b) {
        shieldTime += b;
    }

    public static void setMaxShieldTime(double b) {
        shieldMaxTime = b;
    }

    public static void setShieldTime(double b) {
        shieldTime = b;
    }
}

